package cn.com.duiba.tuia.core.api.dto.jfsite;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * [JF建站]站点域名
 * @author lijicong
 * @since 2020-07-24
 */
@Getter
@Setter
public class JfSiteDomainDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("域名")
    private String domainName;

    @ApiModelProperty(value = "域名类型 0:广告主 1:JF建站")
    private Integer domainType;

    @ApiModelProperty(value = "域名状态 -1:初始化 0:失效 1:正常")
    private Integer domainStatus;

    @ApiModelProperty(value = "失效时间")
    private Date invalidTime;

    @ApiModelProperty(value = "备案状态 -1:初始化 0:异常 1:正常")
    private Integer domainRecordStatus;

    @ApiModelProperty(value = "DNS解析状态 -1:初始化 0:异常 1:正常")
    private Integer domainDnsStatus;

    @ApiModelProperty(value = "CDN状态  -1:初始化 0:异常 1:正常")
    private Integer domainCdnStatus;

    @ApiModelProperty(value = "模拟访问状态 -1:初始化 0:异常 1:正常")
    private Integer domainAccessStatus;

    @ApiModelProperty("账户表ID")
    private Long accountId;

    @ApiModelProperty("创建人ID")
    private Long creatorId;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("修改人")
    private String modifier;

    @ApiModelProperty("修改时间")
    private Date gmtModified;

}