package cn.com.duiba.tuia.core.api.enums.statistics;

/**
 * @Author:zhangmeng
 * @Date:2018-06-29
 * @Function:区分返回给风控标签的类型
 */
public enum TagsTypeEnum {
    /** 标签类型 1：广告行业标签，2：落地页标签，3：属性标签，4：素材标签*/

    /** "广告行业标签"*/
    AD(1,"ad"),

    /** 素材标签*/
    MATERIAL(4,"material"),

    /** 落地页标签*/
    PROMOTE_URL(2,"promoteUrlTag"),

    /** 广告屏蔽标签*/
    BANNED_TAG(3,"advertBannedTag");

    private Integer code;
    private String name;

    TagsTypeEnum(Integer code,String name) {
        this.code=code;
        this.name=name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static TagsTypeEnum getNameByCode(Integer code){
        for(TagsTypeEnum item:TagsTypeEnum.values()){
             if(item.getCode().equals(code)){
                 return item;
             }
        }
        return null;
    }
}
