/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DmpDataUpdatePeridEnum {
    EVERY_TIME(0L, 0, "\u6bcf\u6b21"),
    EVERY_DAY(86400000L, 1, "\u6bcf\u65e5"),
    EVERY_WEEK(604800000L, 2, "\u6bcf\u5468"),
    EVERY_MONTH(2592000000L, 3, "\u6bcf\u6708"),
    NEVERY(-1L, 4, "\u6c38\u4e0d");

    private Long time;
    private Integer code;
    private String desc;
    private static Map<Integer, DmpDataUpdatePeridEnum> codeQueryMap;
    private static Map<Long, DmpDataUpdatePeridEnum> timeQueryMap;

    private DmpDataUpdatePeridEnum(Long time, Integer code, String desc) {
        this.time = time;
        this.code = code;
        this.desc = desc;
    }

    public Long getTime() {
        return this.time;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static DmpDataUpdatePeridEnum getByCode(Integer code) {
        return null == code ? null : codeQueryMap.get(code);
    }

    public static DmpDataUpdatePeridEnum getByTime(Long time) {
        return null == time ? null : timeQueryMap.get(time);
    }

    static {
        codeQueryMap = new ConcurrentHashMap<Integer, DmpDataUpdatePeridEnum>();
        timeQueryMap = new ConcurrentHashMap<Long, DmpDataUpdatePeridEnum>();
        for (DmpDataUpdatePeridEnum typeEnum : DmpDataUpdatePeridEnum.values()) {
            codeQueryMap.put(typeEnum.code, typeEnum);
            timeQueryMap.put(typeEnum.getTime(), typeEnum);
        }
    }
}

