/**
 * 文件名： AdvertiserDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月1日 下午1:36:56
 */
package cn.com.duiba.tuia.core.api.dto;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;

/**
 * @author: leiliang
 * @version:
 */
@Getter
@Setter
public class AccountDto extends BaseDto {

    private static final long serialVersionUID        = 4476874317666316204L;

    /** 邮箱未验证. */
    public static final int   EMAIL_STATUS_UNCHECK    = 0;

    /** 邮箱已验证. */
    public static final int   EMAIL_STATUS_CHECKED    = 1;

    /** 未冻结. */
    public static final int   UNFREEZED_STATUS        = 0;

    /** 已冻结. */
    public static final int   FREEZED_STATUS          = 1;

    /** 审核中. */
    public static final int   CHECK_STATUS_ING        = 0;

    /** 审核通过. */
    public static final int   CHECK_STATUS_PASS       = 1;

    /** 审核拒绝. */
    public static final int   CHECK_STATUS_REFUSE     = 2;

    /** 用户类型：0：广告主. */
    public static final int   USER_TYPE_OF_ADVERTISER = 0;
    
    /** 用户类型：代理商. */
    public static final int   USER_TYPE_AGENT         = 2;
    /**没有分配代理商 的时候分配分配-1*/
    public static final Long NO_AGENT_ID=-1L;

    private static final String SPLITSYMBOL = ".";
    
    /** 代理商最大层级是4级，accountLevel为3. */
    public static final int   MAX_AGENT_LEVEL         = 3;
    
    /** 广告主最大层级是5级，accountLevel为4. */
    public static final int   MAX_ADVERTISER_LEVEL    = 4;

    /** 数据创建来源来源-代理商平台*/
    public static final  int SYSTEM_SOURCE_AGENT=0;
    /** 数据创建来源来源-广告主平台*/
    public static final  int SYSTEM_SOURCE_ADVERTISER=1;
    
    /** 邮箱. */
    private String            email;

    /** 密码. */
    private String            password;

    /** 公司名称. */
    private String            companyName;

    /** 冻结状态:0：未冻结;1：冻结. */
    private Integer           freezeStatus;

    /** 邮箱状态:0：未验证;1：已验证. */
    private Integer           emailStatus;

    /** 审核状态:0：审核中;1：审核通过;2：审核拒绝. */
    private Integer           checkStatus;

    /** 营业执照号. */
    private String            businessLicenseId;

    /** 营业执照名称. */
    private String            businessLicenseName;

    /** 营业执照照片. */
    private String            businessLicenseUrl;

    /** 公司地址. */
    private String            companyAddress;

    /** 联系人姓名. */
    private String            linkman;

    /** 联系人手机号. */
    private String            linkmanPhone;

    /** 联系人QQ. */
    private String            linkmanQQ;

    /** 用户类型. */
    private Integer           userType;

    /** 代理商ID. */
    private Long              agentId;

    /** 代理商公司名. */
    private String            agentCompanyName;

    /** 角色id. */
    private Long              roleId;

    /** 谷歌验证器秘钥. */
    private String            googleAuthKey;

    /** 操作员名. */
    private String            operatorName;

    /** 账户来源：0：兑吧；1-推啊 */
    private Integer           accountSource;

    /**
     * 账号当前所属公司，1-杭州推啊，2-霍尔果斯推啊,3-霍城兑捷
     */
    private Integer companyOwner;
    /**
     * 账号上次主体所属公司，如从未迁过主题则为0:1-杭州推啊，2-霍尔果斯推啊,3-霍城兑捷
     */
    private Integer preCompanyOwner;

    /**
     * 切换主体的状态，1-无主体变更信息，2-处于变更主体的中间态(即切换了新主体，生效的是老主体余额)),3-成功变更了主体信息
     */
    private Integer currentMainStatus;

    //是否签约了多个主体的状态，0-否，1-是
    private Integer multipleMainStatus;

    /** 代理商(广告主)等级 0为最顶级 */
    private Integer           accountLevel;

    /** 上级代理商层级连接，点分隔 */
    private String            accountLevelNum;

    private String auditor;

    private Date auditTime;

    private Date editTime;

    //收件邮箱
    private String receivingMailbox;

    /** 投放状态：0-待选择,1-在投,2-停投.默认为待选择 */
    private Integer putStatus;

    /** 备注 */
    private String remarks;

    /** 广告主类型id:广告主名称TSDT关键词时存在. */
    private Long advertiserType;

    /** 绑定的手机号*/
    private String bindPhone;

    /**
     * 进审时间
     */
    private String enterCheckTime;

    /**广告平台创建这个账户的用户ID,*/
    private Long advertPlatformCreateUserId;

    /**该账户的从什么平台创建 0代理商平台 1广告平台*/
    private Integer systemSource;

	/**
	 * 
	 * getAccountTheLevelNum:(获取当前的代理商层级，算上本级id). <br/>
	 *
	 * @author chencheng
	 * @return
	 * @since JDK 1.8
	 */
	public String getTheLevelNum(){
	    if(this.accountLevel == null){
	        return StringUtils.EMPTY;
	    }
	    if(this.accountLevel == 0){
            return super.id+"";
        }
	    if(this.accountLevelNum==null){
            return StringUtils.EMPTY;
        }
	    return new StringBuilder(this.accountLevelNum).append(SPLITSYMBOL).append(super.id).toString();
	}
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
