package cn.com.duiba.tuia.core.api.remoteservice.ocpc;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.permisson.RoleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * OCPC相关服务
 */
@AdvancedFeignClient
public interface RemoteOCPCService {


   void changeToOCPC(Long packageId) throws BizException;

   boolean canPresetOCPC(Long advertId);

   List<Long> filterWhitePresetOCPC(List<Long> advertIds);

   String getNewTradeByAdvertId(Long advertId);

   /**
    * 根据行业标签查询广告ID
    * @param newTradeList 新行业标签名集合
    * @return
    */
   List<Long> getNewTradeTagAdvertList(List<String> newTradeList);

}
