package cn.com.duiba.tuia.core.api.remoteservice.reflow;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.reflow.AppAutoReflowPlanDTO;
import cn.com.duiba.tuia.core.api.enums.reflow.ReflowPlanStatusEnum;
import cn.com.duiba.tuia.core.api.param.AppAutoReflowPlanParam;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2021/11/22 1:48 下午
 */
@AdvancedFeignClient
public interface RemoteAppAutoReflowPlanService {

    /**
     * 保存媒体数据自动回流计划
     *
     * @param appAutoReflowPlanDTO
     * @return
     */
    boolean save(AppAutoReflowPlanDTO appAutoReflowPlanDTO);

    /**
     * 更新媒体自动回流计划
     *
     * @param appAutoReflowPlanDTO
     * @return
     */
    boolean update(AppAutoReflowPlanDTO appAutoReflowPlanDTO);

    /**
     *  分页查询媒体自动回流计划
     *
     * @param appAutoReflowPlanParam
     * @return
     */
    PageDto<AppAutoReflowPlanDTO> pageQuery(AppAutoReflowPlanParam appAutoReflowPlanParam);

    /**
     * @param id
     * @return
     */
    AppAutoReflowPlanDTO findAppAutoReflowPlanById(Long id);

    /**
     * 根据平台名称获取今天可以执行的任务
     *
     * @param platform {@link cn.com.duiba.tuia.core.api.enums.reflow.AppAutoReflowEnum}
     * @param dateStr  2021-11-23
     * @return
     */
    List<AppAutoReflowPlanDTO> getTodayValidPlansByPlatform(String platform, String dateStr);

    /**
     * 根据外部账号Id，获取所有已经绑定的外部广告ID
     *
     * @param externalAccountId
     * @param id
     * @return
     */
    List<String> getAdvertStrByExternalAccountId(Long externalAccountId, Long id);

    /**
     * 更新媒体回流计划状态
     *
     * @param id
     * @param planStatus {@link ReflowPlanStatusEnum}
     * @return
     */
    boolean updatePlanStatus(Long id, Integer planStatus);

}
