/**
 * Project Name:manager-domain File Name:GetAppDataReq.java Package Name:cn.com.duiba.tuia.manager.req
 * Date:2016年5月25日下午4:48:23 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.data;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.QueryDto;

/**
 * ClassName:GetAppDataReq <br/>
 * Function: 广告-媒体每日转化数据请求参数 <br/>
 * Date: 2016年5月25日 下午4:48:23 <br/>
 * .
 *
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqAdvertTransformDay extends QueryDto {

    private static final long serialVersionUID = 1013758238340533244L;

    /** 广告ID. */
    private Long              advertId;

    /** 活动类型：0-互动广告，1-展示广告 */
    private Integer           activityType;

    /** 广告IDs. */
    private List<Long> advertIds;

    /** 0 or null ：汇总，1：分日 */
    private Integer exportType;

    public Integer getExportType() { return exportType; }

    public void setExportType(Integer exportType) { this.exportType = exportType; }

    public List<Long> getAdvertIds() { return advertIds; }

    public void setAdvertIds(List<Long> advertIds) { this.advertIds = advertIds; }

    public ReqAdvertTransformDay(Long advertId, Date startDate, Date endDate) {
        super.setStartDate(startDate);
        super.setEndDate(endDate);
        this.advertId = advertId;
    }

    public ReqAdvertTransformDay() {
        super();
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * To string.
     *
     * @return the string
     * @see Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
