package cn.com.duiba.tuia.core.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * @author lijicong
 * @since 2020-07-30
 */
public abstract class JfsiteEnums {

    // 域名类型 0:广告主 1:JF建站
    @Getter
    @AllArgsConstructor
    public enum DomainTypeEnum {
        DOMAIN_TYPE_0(0, "广告主"),
        DOMAIN_TYPE_1(1, "JF建站"),
        ;

        private Integer code;
        private String description;

    }

    // 问题类型 0:加粉
    @Getter
    @AllArgsConstructor
    public enum IssueTypeEnum {
        ISSUE_TYPE_0(0, "加粉"),
        ;

        private Integer code;
        private String description;
    }

    // 账号状态 0:冻结 1:正常
    @Getter
    @AllArgsConstructor
    public enum AccountStatusEnum {
        ACCOUNT_STATUS_0(0, "冻结"),
        ACCOUNT_STATUS_1(1, "正常"),
        ;

        private Integer code;
        private String description;
    }

    // 备案状态、DNS解析状态、模拟访问状态、域名状态、CDN状态 -1:初始化 0:异常 1:正常
    @Getter
    @AllArgsConstructor
    public enum StatusEnum {
        STATUS_N1(-1, "初始化"),
        STATUS_0(0, "异常"),
        STATUS_1(1, "正常"),
        ;

        private Integer code;
        private String description;
    }
}
