package cn.com.duiba.tuia.core.api.enums;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2021/7/6
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum LinkTypeEnum {
    ADVERT_PROMOTION(1, "广告推广链接"),
    DIRECTIONAL_CONFIGURATION(2, "定向配置链接"),
    AB_TEST(3, "AB测试"),
    MATERIAL_BING_LAND_PAGE_TEST(4, "素材绑定落地页测试"),;
    private Integer code;

    private String desc;

    LinkTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code){
        for (LinkTypeEnum linkTypeEnum : LinkTypeEnum.values()){
            if(linkTypeEnum.getCode().equals(code)){
                return linkTypeEnum.desc;
            }
        }
        return "";
    }

}
