package cn.com.duiba.tuia.core.api.enums;

/**
 * @author zhangmeng
 * @date 2019/7/5
 * @function 潜力广告对应行业
 */
public enum PotentionalAdvertTradeEnum {

    HUO_DAO_FU_KUAN(0,"下单/转化","货到付款"),

    HUI_JI_KA(1,"表单提交","会籍卡"),

    DAI_KUAN(2,"授信","贷款"),

    YOU_XI(3,"注册","游戏"),

    YING_YONG_FEN_FA(4,"激活","应用分发"),

    XIN_WEN_ZI_XUN(5,"激活","新闻资讯"),

    DIAN_SHANG_PING_TAI(6,"激活","电商平台"),

    BAO_XIAN(7,"表单提交","保险"),

    UNKNOW(-1,"未知","未知");

    private String tradeName;

    private String tradeCost;

    private int code;

    PotentionalAdvertTradeEnum(int code,String tradeCost,String tradeName) {
        this.tradeName = tradeName;
        this.tradeCost = tradeCost;
        this.code = code;
    }

    public static PotentionalAdvertTradeEnum getCodeByName(String tradeName){

        for(PotentionalAdvertTradeEnum item:PotentionalAdvertTradeEnum.values()){

            if(item.getTradeName().equals(tradeName)){
                return item;
            }
        }

        return UNKNOW;
    }

    public String getTradeName() {
        return tradeName;
    }

    public String getTradeCost() {
        return tradeCost;
    }

    public int getCode() {
        return code;
    }
}
