package cn.com.duiba.tuia.core.api.remoteservice.partner;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.AdvertiserDateSelectSecretKeyDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.req.ReqAdvertiserDateSelectSecretKeyDto;

import java.util.List;

@AdvancedFeignClient
public interface RemotePartnerService {

    /**
     * 获取合作方的秘钥
     * @param partnerId
     * @return
     */
    String getSecretById(Long partnerId);

    /**
     * 获取合作方ID
     * @param partnerId
     * @return
     */
    Long getAccountIdById(Long partnerId);

    /**
     *  插入
     */
    int insertdataSelectAdvertiserSecretKey(Long accountId,String accountName,String secret );


    int count(ReqAdvertiserDateSelectSecretKeyDto param);

    PageDto<AdvertiserDateSelectSecretKeyDto> listPartner(ReqAdvertiserDateSelectSecretKeyDto param);

    Long maxId();

}
