package cn.com.duiba.tuia.core.api.remoteservice.slot;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.app.IdAndAmountDto;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotWhiteListDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by jzl on 18/4/2.
 */
@AdvancedFeignClient
public interface RemoteSlotWhiteListService {

    /**
     * 查询白名单列表 slotId
     * @param slotId
     * @return
     */
    DubboResult<List<SlotWhiteListDto>> getListBySlotId(Long slotId);

    /**
     * 根据appId获取白名单列表
     * @param appId
     * @return
     */
    List<SlotWhiteListDto> getListByAppId(Long appId);

    /**
     * 插入白名单
     * @param slotWhiteListDto
     */
    void insertSlotWhiteListDto(SlotWhiteListDto slotWhiteListDto);

    /**
     * 删除关联关系
     * @param advertIds
     */
    void deleteByAdvertIds(List<Long> advertIds);

    /**
     * 根据slotId和advertId查询白名单
     * @param slotId
     * @param advertId
     * @param strategyId
     * @param type
     * @return
     */
    DubboResult<SlotWhiteListDto> selectBySlotIdAndAdvertId(Long slotId, Long advertId, Long strategyId, String type);

    /**
     * 查看该slot下最大排序值
     * @param slotId
     * @param strategyId
     * @param type
     * @return
     */
    DubboResult<Integer> selectMaxOrderLevel(Long slotId, Long strategyId, String type);

    /**
     * 查询该slot下最小排序值
     * @param slotId
     * @param strategyId
     * @param type
     * @return
     */
    DubboResult<Integer> selectMinOrderLevel(Long slotId, Long strategyId, String type);

    /**
     * 绑定广告位与广告
     * @param appId
     * @param slotId
     * @param advertId
     * @param orderLevel
     * @param strategyId
     * @param type
     * @return
     */
    DubboResult<Integer> bindAdvert(Long appId, Long slotId, Long advertId, Integer orderLevel, Long strategyId, String type);

    /**
     * 更新该广告在此广告位中的排序.
     *
     * @param id         the id
     * @param orderLevel the order level
     */
    DubboResult<Integer> updateOrder(Long id, Integer orderLevel);

    /**
     * 给该广告位下orderLevel大于修改排序的广告排序.
     *
     * @param slotId      the slot id
     * @param orderLevel the order level
     * @param strategyId
     * @param type
     */
    DubboResult<Integer> updateBindOrder(Long slotId, Integer orderLevel, Long strategyId, String type);

    /**
     * 删除一条slot绑定的广告记录.
     *
     * @param id the id
     * @return the int
     */
    DubboResult<Integer> delete(Long id);

    /**
     * 通过slotId和策略id查询绑定的广告计划.
     * 策略id是新媒体流量策略定制时传递
     *
     * @param slotId      the slot id
     * @param strategyId
     * @param type
     * @return the list< slot white list dto>
     */
    DubboResult<List<SlotWhiteListDto>> selectWhiteListBySlotId(Long slotId, Long strategyId, String type);

    List<SlotWhiteListDto> selectWhiteListBySlotIdsAndAdvertId(List<Long> slotIds, Long advertId);

    /**
     * 查询广告位下的白名单数量
     * @param slotId
     * @param strategyId
     * @param type
     * @return
     */
    DubboResult<Integer> selectCountsBySlotId(Long slotId, Long strategyId, String type);

    /**
     * 批量查询广告位下的白名单数量
     * @param slotIds
     * @param strategyId
     * @param type
     * @return
     */
    DubboResult<List<IdAndAmountDto>> selectCountsBySlotIds(List<Long> slotIds, Long strategyId, String type);
    
    /**
     * 
     * batchUpdateSoltWhiteList:(批量更新广告位排序). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    Integer batchUpdateSoltWhiteList(List<SlotWhiteListDto> list);

    /**
     * 批量绑定广告位与广告
     * @param appId  媒体Id
     * @param slotId 广告位Id
     * @param advertIds 广告Id列表
     * @param orderLevel
     * @param strategyId 策略Id
     * @param type 策略类型
     * @return
     */
    DubboResult<Integer> batchBindAdvert(Long appId, Long slotId, List<Long> advertIds, Integer orderLevel, Long strategyId, String type);

    /**
     * 根据广告位ID和广告ID集合
     * @param slotId
     * @param returnAdvertIds
     * @param strategyId
     * @param type
     * @return
     */
    List<SlotWhiteListDto> selectBySlotIdAndAdvertIds(Long slotId, List<Long> returnAdvertIds, Long strategyId, String type);
}
