package cn.com.duiba.tuia.core.api.remoteservice.tag;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.tag.FeatureTagDTO;
import cn.com.duiba.tuia.core.api.dto.tag.FeatureTagFormDTO;
import cn.com.duiba.tuia.core.api.dto.tag.FeatureTagQueryDTO;

import java.util.List;

/**
 * 特征标签库 RemoteService
 * @author lijicong
 * @since 2021-02-07
 */
@AdvancedFeignClient
public interface RemoteFeatureTagService {

    FeatureTagDTO queryById(Long id);

    List<FeatureTagDTO> queryList(FeatureTagQueryDTO queryDTO);

    List<FeatureTagDTO> queryTreeList(FeatureTagQueryDTO queryDTO);

    long queryCount(FeatureTagQueryDTO queryDTO);

    int add(FeatureTagFormDTO formDTO);

    int edit(FeatureTagFormDTO formDTO);

    int delete(Long id);
}