package cn.com.duiba.tuia.core.api.dto.move;


import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by huangch on 2019/4/23 10:44
 * description:
 *
 * @since JDK 1.6
 */
public class MoveFixData implements Serializable {

    private static final long serialVersionUID = -4593843583568698805L;

    private Map<Long, FixAccount> fixAccountMap = Maps.newHashMap();

    private Map<Long, FixAccount> newTopAgentAccountMap = Maps.newHashMap();

    public List<Long> getFixAccountIds(Long agentId) {
        FixAccount fixAccount = fixAccountMap.get(agentId);

        if (fixAccount == null) {
            return Collections.emptyList();
        }

        return fixAccount.getFixAccountIds();
    }

    public Date getFixDate(Long agentId) {
        FixAccount fixAccount = fixAccountMap.get(agentId);

        if (fixAccount == null) {
            return null;
        }

        return fixAccount.getFixDate();
    }

    public boolean isMoveAgent(Long agentId) {
        return fixAccountMap.get(agentId) != null;
    }

    public boolean isMoveNewAgent(Long agentId) {
        return newTopAgentAccountMap.get(agentId) != null;
    }

    public Date getNewAgentFixDate(Long agentId) {
        FixAccount fixAccount = newTopAgentAccountMap.get(agentId);

        if (fixAccount == null) {
            return null;
        }

        return fixAccount.getFixDate();
    }

    public List<Long> getNewAgentFixAccountIds(Long agentId) {
        FixAccount fixAccount = newTopAgentAccountMap.get(agentId);

        if (fixAccount == null) {
            return Collections.emptyList();
        }

        return fixAccount.getFixAccountIds();
    }

    public Map<Long, FixAccount> getFixAccountMap() {
        return fixAccountMap;
    }

    public void setFixAccountMap(Map<Long, FixAccount> fixAccountMap) {
        this.fixAccountMap = fixAccountMap;
    }

    public Map<Long, FixAccount> getNewTopAgentAccountMap() {
        return newTopAgentAccountMap;
    }

    public void setNewTopAgentAccountMap(Map<Long, FixAccount> newTopAgentAccountMap) {
        this.newTopAgentAccountMap = newTopAgentAccountMap;
    }
}
