package cn.com.duiba.tuia.core.api.dto.risk;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * 提供给风控使用的基础广告信息
 */
@Data
@ToString
public class AdvertBaseRiskInfoDto implements Serializable {


    private static final long serialVersionUID = -4593749732905089345L;

    /**
     * 广告id
     */
    private Long advertId;

    /**
     * 广告名称
     */
    private String advertName;

    /**
     * 有效状态.
     */
    private Integer validStatus;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 类型 0-广告，1-广告主
     */
    private Integer type;

    /**
     * 代理商名称
     */
    private String agentName;

    /**
     * 审核时长（当前时间-进审时间）格式化为n分钟、n小时、超过24小时显示为 >1天
     */
    private Long waitTime;

    /**
     * 广告类型
     */
    private Integer advertType;

}
