package cn.com.duiba.tuia.core.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 落地页日志导出维度名称
 *
 * @author chencheng
 * @version
 */
public enum AdvertLoadingPageNameEnum {
    /** 地域.--省份 */
    ADVERT_LOADING_PAGE_PROVINCE("province", "省份"),

    /** 地域.--城市 */
    ADVERT_LOADING_PAGE_CITY("city", "城市"),

    /** 设备价值. */
    ADVERT_LOADING_PAGE_PHONE("phone", "设备价值"),
    
    /** 平台. */
    ADVERT_LOADING_PAGE_PLATFORM("platform", "平台"),
    
    /** 时段. */
    ADVERT_LOADING_PAGE_HOUR("hour", "时段"),
    
    /** 媒体. */
    ADVERT_LOADING_PAGE_APP("app", "媒体"),

    /** 点击位置. */
    ADVERT_LOADING_PAGE_CLICK("click", "点击位置");

    /** 代码 */
    private String code;
    /** 描述 */
    private String desc;

    private AdvertLoadingPageNameEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AdvertLoadingPageNameEnum getByCode(String code) {
        for (AdvertLoadingPageNameEnum enumVal : AdvertLoadingPageNameEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
