package cn.com.duiba.tuia.core.api.enums;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2021/7/6
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum AuditStatusEnum {
    /**
     * 审核中
     */
    UNDER_REVIEW(1, "审核中"),
    /**
     * 审核通过
     */
    APPROVE(2, "审核通过"),
    /**
     *审核拒绝
     */
    REJECT(3, "审核拒绝"),
    /**
     * 删除记录
     */
    REMOVE(-1, "删除记录"),;

    private Integer code;

    private String desc;

    AuditStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code){
        for (AuditStatusEnum auditStatusEnum : AuditStatusEnum.values()){
            if(auditStatusEnum.getCode().equals(code)){
                return auditStatusEnum.desc;
            }
        }
        return "";
    }
}
