package cn.com.duiba.tuia.core.api.enums.compensate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 自动赔付入账状态枚举
 *
 * @author zhangbaiqiang
 * @date 2021/4/27
 */
@Getter
@AllArgsConstructor
public enum EntryStateEnum {

    INVALID(0, "无效"),
    READY_TO_ENTRY(1, "待入账"),
    ALREADY_ENTRY(2, "已入账");

    private final Integer state;
    private final String  desc;

    public static String getDesc(Integer state) {
        return Stream.of(EntryStateEnum.values())
                .filter(e -> Objects.equals(e.getState(), state))
                .findFirst()
                .map(EntryStateEnum::getDesc)
                .orElse(null);
    }
}
