package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialDto;
import cn.com.duiba.tuia.core.api.dto.CreateNewMaterialDto;

import java.util.Map;

/**
 * @Author:zhangmeng
 * @Date:2018/8/23
 * @Function:互动广告默认素材修改后不停投
 */
@AdvancedFeignClient
public interface RemoteCreateDefaultMaterial {


    /**
     *修改默认素材后，创建新素材（原素材1，2，..n）,激活状态，并且送审
     */
    boolean createDefaultMaterial(CreateNewMaterialDto createNewMaterialDto);
    /**
     * 保存素材时候，判断当前素材 商品名称，一句话描述，马上使用按钮文案，详情页banner
     */

    /**
     * 通过修改默认素材，新增的素材审核通过，将原默认素材设置为屏蔽态，并且替换原默认素材
     */
    Map<String,Object> replaceDefaultMaterial(Long materialId,Integer type);

    /**
     * 页面设置默认素材，需要判素材，是否为激活，审批通过，且不为试投素材
     */
    boolean checkIsAvailableMaterial(Long materialId,Long advertId);

    /**
     * 素材复审逻辑
     *   1.如果默认素材被拒绝，则判断当前广告下是否有可用素材（激活，审核通过，非试投），
     *   有的话则将最新上传的可用素材设置为默认
     *
     *   没有的话则将当前广告设置为拒绝状态，要发消息
     */
    String reCheckMaterial(Long materialId);

    /**
     * 审核当前广告下是否有，新建的默认素材正在审核
     * @param advertId
     * @return
     */
    boolean checkHaveMaterialAudit(Long advertId);

    /**
     * 检查当前广告是否是互动广告
     * @param advertId
     * @return
     */
    boolean checkIsInteractAdvert(Long advertId);

    /**
     * 判断 是否修改了，商品名称，一句话描述，按钮文案，banner图片
     * @param createNewMaterialDto
     * @return
     */
    boolean checkDefaultIsChange(CreateNewMaterialDto createNewMaterialDto);

    /**
     * 查询广告下，最新的一个通过修改默认素材创建的素材，且是审核通过或者审核拒绝
     */
    Map<String,String> getRecentMaterial(Long advertId);

    /**
     * 组合日志
     * @param map
     * @return
     */
    String contributRecord(Map<String,Object> map,Integer type);

    /**
     * 判断非商品名称，一句话描述，按钮文案，banner图片，的优惠券信息是否修改
     * @param createNewMaterialDto
     * @return
     */
    boolean checkOtherIsChange(CreateNewMaterialDto createNewMaterialDto);
}
