package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.DmpAdvertDataDto;
import cn.com.duiba.tuia.core.api.dto.DmpDto;
import cn.com.duiba.tuia.core.api.dto.DmpTagDto;

import java.util.List;

/**
 * @Author:zhangmeng
 * @Date:2018/9/10
 * @Function:
 */
@AdvancedFeignClient
public interface RemoteDmpAdvertService {

    /**
     * 添加测试广告
     */
    boolean addDmpAdvert(DmpAdvertDataDto dmpAdvertDataDto);

    /**
     * 查询所有有效的测试广告
     */
    List<DmpAdvertDataDto> getAllValidateDmpAdvert();

    /**
     * 删除测试广告
     */
    boolean deleteDmpAdvertData(Long id);

    /**
     * 编辑dmp 测试 的 广告
     */
    Boolean updDmpAdvert(DmpAdvertDataDto dmpAdvertDataDto);

    /**
     * 查询所有 的 dmp
     */
    List<DmpDto> findAllDmp();

    /**
     * 编辑测试的dmp
     */
    Boolean updAllTestDmp(List<DmpDto> dmpDtos);


    /**
     * 添加dmp测试标签（人群包）
     */
    Long addDmpTag(DmpTagDto req);

    /**
     * 编辑dmp测试标签（人群包）
     */
    Boolean updDmpTag(DmpTagDto req);

    /**
     * 删除dmp测试标签（人群包）
     */
    Boolean delDmpTag(Long req);

    /**
     * 查询所有的测试标签
     */
    List<DmpTagDto> queryAllDmpTags();

}
