package cn.com.duiba.tuia.core.api.remoteservice.media;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaAlreadSlotWhiteReq;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaCopySlotWhiteReq;
import cn.com.duiba.tuia.core.api.dto.media.response.*;

import java.util.List;

/**
 * @author zhangmeng
 * @date 2019/6/26
 * @function 广告位白名单
 */
@AdvancedFeignClient
public interface RemoteMediaAppWhiteListService {

    /**
     * 提供广告位白名单数量,福袋状态（应用管理）
     */
    RspMediaSlotWhiteDto getSlotWhiteCountAndLuckBagStatus(Long slotId);



    RspMediaSlotAdvertAccountDto getWhiteAdvertAndAccountBySlotIds(List<Long> slotIds);

    /**
     * 根据广告位查询在投广告信息
     * @param slotIds
     * @return
     */
    List<MediaAdvertInfoDTO> queryWhiteAdvertInfoBySlotIds(List<Long> slotIds);

    /**
     * 覆盖白名单
     * @param mediaCopySlotWhiteReq
     * @return
     */
    Boolean coverMediaSlotWhite(MediaCopySlotWhiteReq mediaCopySlotWhiteReq);

    /**
     * 提供复制白名单接口，参数 原广告位 solt1，目标广告位 solt2，sot3，。。。总共不超过10个。
     * （如果广告位同时在广告主，又在广告位白名单中，复制时候只需要复制广告主就可以了）
     */
    Boolean copyMediaSlotWhite(MediaCopySlotWhiteReq mediaCopySlotWhiteReq);


    /**
     * 批量将广告加入到广告位对应的白名单中
     */
    Boolean batchAddAdvertToWhiteList(Long slotId, List<Long> advertIds) throws BizException;


    /**
     * 批量将广告主加入到广告主广告位白名单中
     */
    Boolean batchAddAccountToWhiteList(Long slotId,List<Long> accountIds) throws BizException;

    /**
     * 单个将广告从广告位白名单中移除
     */
    Boolean removeAdvertFromWhiteList(Long slotId,Long advertId);


    /**
     * 单个将广告主从广告主白名单中移除
     */
    Boolean removeAccountFromWhiteList(Long slotId,Long accountId);


    /**
     * 查询广告已添加到广告位白名单下的广告计划(需要分页) List<RspMediaSlotAdvertWhiteDto>
     */
    PageDto<RspMediaSlotAdvertWhiteDto> getAlreadAdvertSlotWhiteList(MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);



    /**
     * 查询广告主已添加到广告位白名单下的广告主（需要分页）List<RspMediaSlotAccountWhiteDto>
     */
    PageDto<RspMediaSlotAccountWhiteDto> getAlreadAccountSlotWhiteList(MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);


    /**
     * 根据广告id/广告名称/广告主id/广告主名称   查询广告信息（需要分页） List<RspMediaSlotAdvertWhiteDto>
     */

    PageDto<RspMediaSlotAdvertWhiteDto> getAdvertSlotWhiteList(MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);


    /**
     * 根据广告主id/广告主名称 查询广告主信息（需要分页）List<RspMediaSlotAccountWhiteDto
     */
    PageDto<RspMediaSlotAccountWhiteDto> getAccountSlotWhiteList(MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);

    /**
     * 查询当前 广告下这些媒体对它的屏蔽状态
     * 媒体 下所有广告为都屏蔽了此媒体,则 为完全屏蔽-2，如果媒体下部分广告为屏蔽了广告-1,媒体下无广告位屏蔽广告-0
     */
    List<RspMediaSlotShieldDto> getMediaShieldStatus(Long advertId,List<Long> appIds);

    /**
     * 查询当前 广告下这些广告位对它的屏蔽状态
     * @param advertId
     * @param slotIds
     * @return
     */
    List<Long> getMediaSlotShieldStatus(Long advertId,List<Long> slotIds);

    /**
     * 将广告从广告位白名单中批量删除
     */
    Boolean batchRemoveAdvertFromWhiteList(Long slotId, List<Long> advertIds);

    /**
     * 将广告主从广告主白名单中批量删除
     */
    Boolean batchRemoveAccountFromWhiteList(Long slotId, List<Long> accountIds);
}
