package cn.com.duiba.tuia.core.api.remoteservice.promotetest;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.MaterialPromoteTestDto;
import cn.com.duiba.tuia.core.api.dto.PromoteTestAuditQueryDto;
import cn.com.duiba.tuia.core.api.dto.PromoteUrlDto;
import cn.com.duiba.tuia.core.api.dto.req.PromoteTestCheckReq;
import cn.com.duiba.tuia.core.api.dto.req.ReqPromoteTestAuditQuery;
import cn.com.duiba.tuia.core.api.dto.rsp.promotetest.AdvertPromoteTestDto;
import cn.com.duiba.tuia.core.api.dto.statistics.AdvertMaterialPromoteStatisticDto;
import cn.com.duiba.tuia.core.api.param.MultipleDateParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**测试落地页远程服务提供
 * Created by jzl on 18/5/14.
 */
@AdvancedFeignClient
public interface RemotePromoteTestService {

    /**
     * 查询测试落地页集合,该接口只查询A/B TEST的落地页测试链接，即url_type=0的数据
     * @param advertId
     * @return
     */
    List<AdvertPromoteTestDto> findPromoteListByAdvertId(Long advertId);

    /**
     * 查询测试落地页集合,带已删除的数据
     * @param advertId
     * @return
     */
    List<AdvertPromoteTestDto> findPromoteListWithDeletedByAdvertId(Long advertId);


    /**
     * 这个接口是用于写了新的落地页测试  用来判断老的落地页测试 是否存在 进行中1,待审核中0,2.审核拒绝,等状态
     * 这里的有效 认为0, 1,2,3 都算有效.4删除才算无效.
     * @author fanjia
     * @date 2021/7/8 下午3:44
     * @param advertId
     * @return  true代表 代表有 false代表没有
     */
    Boolean haveValidPromoteTest(Long advertId);


    /**
     * 活动是否配置了广告落地页弹层测试
     * @return
     */
    Boolean isConfigLayerTest(Long advertId);

    /**
     * 新增或修改
     * @param advertPromoteTestDto
     * @return
     */
    Integer addOrUpdatePromoteTestUrl(AdvertPromoteTestDto advertPromoteTestDto);

    /**
     * 删除广告下的全部测试落地页，及关联的素材
     * @param advertId
     * @return
     */
    Integer deleteAllByAdvertId(Long advertId);

    Integer updatePromoteTestUrlById(AdvertPromoteTestDto advertPromoteTestDto);

    AdvertPromoteTestDto selectById(Long id);

    Integer addPromoteTestUrl(AdvertPromoteTestDto advertPromoteTestDto);

    /**
     * 查询广告新媒体推广链接，一个广告志辉有一个生效的
     *
     * @param advertId 广告ID
     * @param status   审核状态，可以为空
     * @return
     */
    AdvertPromoteTestDto queryAdvertNewAppPromoteTest(Long advertId, Integer status);

    /**
     * 删除单个测试落地页，及关联的素材
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 分页查询测试落地页
     * @param req
     * @return
     */
    List<PromoteTestAuditQueryDto> findPromoteTestAuditQuery(ReqPromoteTestAuditQuery req);

    /**
     * 分页查询测试落地页
     * @param req
     * @param  needRecheckRecord 审核记录是否需要复审的  true 需要  false 不需要
     * @return
     */
    List<PromoteTestAuditQueryDto> findPromoteTestAuditQueryAndIsNeedRecheckRecord(ReqPromoteTestAuditQuery req,Boolean needRecheckRecord);

    /**
     * 查询数量
     * @param req
     * @return
     */
    Integer findPromoteTestAuditQueryCount(ReqPromoteTestAuditQuery req);

    /**
     * 审核
     * @param req
     * @return
     */
    Integer auditPassOrReject(PromoteTestCheckReq req) throws BizException;

    /**
     * 查询审核通过的测试落地页,查询A/B TEST和落地页库的测试链接，即url_type=0,4
     * @param advertId
     * @param status
     * @return
     */
    List<AdvertPromoteTestDto> findPromoteListByAdvertIdAndStatus(Long advertId, Integer status);

    /**
     * 素材审核选择落地页提交接口
     * @param id
     * @param materialId
     * @return
     */
    Integer materialPromoteAudit(Long id, Long materialId);

    /**
     * 查询广告－落地页回流统计数据
     * @param advertId
     * @param sourceType 1-查询全局数据，2-查询分类数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticData(Long advertId, Integer sourceType, Integer exportType, Date startDate, Date endDate);

    /**
     * 查询广告－落地页回流统计数据
     * @param advertId
     * @param params 多段时间
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticDataByMultipleDate(Long advertId, List<MultipleDateParam> params);

    /**
     * 查询素材－广告－落地页回流统计数据
     * @param advertId
     * @param materialId
     * @param sourceType 1-查询全局数据，2-查询分类数据
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findMaterialAdvertPromoteStatisticData(Long advertId, Long materialId, Integer sourceType, Integer exportType, Date startDate, Date endDate);

    /**
     * 查询素材的所有url的统计数据
     * @param advertIds
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findMaterialAdvertPromoteStatisticDataByMaterial(List<Long> advertIds,Integer exportType, Date startDate, Date endDate);

    /**
     * 根据advertId查询素材ID集合
     * @param advertId
     * @return
     */
    List<Long> findMaterialIdsByAdvertId(Long advertId);

    /**
     * 根据Id查询素材ID集合
     * @param id
     * @return
     */
    List<Long> findMaterialIdsById(Long id);


    /**
     * 广告——落地页按 advertIds统计
     * @param advertIds
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticDataByAdvertIds(List<Long> advertIds, Date startDate, Date endDate);

    /**
     * 广告——落地页按 advertIds统计 分组条件 advert_id , promote_url  cur_date
     * @param advertIds
     * @param startDate
     * @param endDate
     * @return
     */
    List<AdvertMaterialPromoteStatisticDto> findAdvertPromoteStatisticDataByAdvertIdsGroupByCurDate(List<Long> advertIds, Date startDate, Date endDate) ;
    /**
     * 
     * handleUrlsMD5ToPromoteUrl:(获取加密落地页链接对应的原始链接). <br/>
     *
     * @author chencheng
     * @param urlsMd5
     * @return
     * @since JDK 1.8
     */
    Map<String, String> handleUrlsMD5ToPromoteUrl(List<String> urlsMd5);

    /**
     * 根据测试落地页ID集合查询所有的关系
     * @param promoteIds
     * @return
     */
    List<MaterialPromoteTestDto> selectByPromoteIdList(List<Long> promoteIds);

    /**
     * 更新该广告的落地页测试在实验平台的数据
     *
     * @param advertId 广告Id
     */
    void updatePromoteABTestByAdvertId(Long advertId);

    /**
     * 根据广告列表获取URL
     *
     * @param advertList
     * @return
     */
    List<String> getUrlListByIds(List<Long> advertList);

    /**
     * url反查广告
     * @param urlList
     * @return
     */
    List<PromoteUrlDto> getAdvertListByUrlList(List<String> urlList);

    /**
     * 更新落地页审核进审时，命中的落地页标签
     * @param dto
     * @return
     */
    Integer updateWordHitTag(AdvertPromoteTestDto dto);

    /**
     * 根据ID 更新落地页标签
     * @param dto
     * @return
     */
    Integer updatePromoteTag(AdvertPromoteTestDto dto);

    /**
     * 删除素材和测试落地页的关联
     *
     * @param materialId 素材Id
     * @return 删除数量
     */
    Integer deleteMaterialPromoteTest(Long materialId);

    /**
     * 根据素材id查询询所有的关系
     * @param materialId
     * @return
     */
    List<MaterialPromoteTestDto> selectByMaterialId(Long materialId);

    /**
     * 落地页绑定素材->先删除后新增绑定 -记得刷缓存
     * @author fanjia
     * @date 2021/9/9 上午11:50
     * @param promoteId
     * @param materialIdList
     * @return int
     */
    Boolean deleteAndInsertMaterialPromoteTest(Long promoteId,List<Long> materialIdList);
}
