package cn.com.duiba.tuia.core.api.remoteservice.wechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 微信第三方平台相关接口
 */
@AdvancedFeignClient
public interface RemoteWechatThirdPlatformService {
    /**
     * 获取授权链接
     * @param preAuthCode
     * @return
     */
    String getAuthLink(String preAuthCode);

    /**
     * 第三方平台componentVerifyTicket推送
     * @param timestamp
     * @param nonce
     * @param msgSignature
     * @param postData
     */
    void componentVerifyTicketCallback(String timestamp, String nonce, String msgSignature, String postData);

    /**
     * 小程序授权成功回调
     * @param authorizerAuthCode 授权码
     */
    void authSuccessCallback(String authorizerAuthCode);

}
