package cn.com.duiba.tuia.core.api.dto.account;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
*
*  @author zhanganbo
*/
@Data
public class AccountAccountCompanySwitchRecordDTO implements Serializable {


    private static final long serialVersionUID = 1316512464945241495L;
    /**
    * 主键
    * 
    * isNullAble:0
    */
    private Long id;

    /**
    * 账号id
    * isNullAble:0
    */
    private Long accountId;

    /**
    * 账号所属公司，1-杭州推啊，2-霍尔果斯推啊,3-霍城兑捷
    * isNullAble:0,defaultVal:1
    */
    private Integer preCompanyOwner;

    /**
    * 账号所属公司，1-杭州推啊，2-霍尔果斯推啊,3-霍城兑捷
    * isNullAble:0,defaultVal:1
    */
    private Integer curCompanyOwner;

    /**
    * 所属代理商ID， 如果本身为代理商， 则为空
    * isNullAble:0,defaultVal:0
    */
    private Long agentId;

    /**
    * 用户类型(0：广告主，2：代理商)
    * isNullAble:1,defaultVal:0
    */
    private Integer accountType;

    /**
    * 余额生效类型，1-一级代理商切换销售，2-广告主中间态且老主体余额为0直接切换，3-广告主消耗切换
    * isNullAble:0,defaultVal:1
    */
    private Integer balanceEffectType;

    /**
    * 创建时间
    * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
    */
    private Date gmtCreate;

    /**
    * 修改时间
    * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
    */
    private Date gmtModified;


}
