package cn.com.duiba.tuia.core.api.dto.rsp.account;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 广告主资质查询记录详情
 * </p>
 *
 * @author chl
 * @since 2021-10-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class QualificationQueryDetailDto {

    private static final long serialVersionUID = 1L;


    private Long id;
    /**
     * 记录id
     */
    private String recordId;

    /**
     * 行业id
     */
    private Long tradeId;

    /**
     * 行业名称
     */
    private String tradeName;

    /**
     * 广告主名称
     */
    private String advertiserName;

    /**
     * 资质名称
     */
    private String qualificationName;

    /**
     * 消耗金额
     */
    private BigDecimal consumeAmount;

    /**
     * 资源链接
     */
    private String resourceUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
