/**
 * Project Name:tuia-core-api<br>
 * File Name:AppDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月9日下午4:35:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto.rsp.app;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * json 2017年4月14日 下午2:50:24 <br/>
 *
 * @author chencheng
 * @version
 */
public class ValidPeriodJsonDto implements Serializable {

    private static final long serialVersionUID = 880445882866057522L;

    /** 有效周 */
    private int               week;

    /** 有效时段 */
    private List<HourDto>     time;

    public ValidPeriodJsonDto() {}

    public static class HourDto implements Serializable {

        private static final long serialVersionUID = 1541595213129214494L;

        /** 有效开始小时 */
        private String            startHour;

        /** 有效结束小时 */
        private String            endHour;

        /** 有效结束小时 */
        private Boolean            effect;

        public HourDto(String startHour, String endHour) {
            super();
            this.startHour = startHour;
            this.endHour = endHour;
        }

        public HourDto(String startHour, String endHour, Boolean effect) {
            super();
            this.startHour = startHour;
            this.endHour = endHour;
            this.effect = effect;
        }

        public HourDto() {}

        /**
         * effect.
         *
         * @return the effect
         */
        public Boolean getEffect() {
            return effect;
        }

        /**
         * effect.
         *
         * @param effect the effect to set
         */
        public void setEffect(Boolean effect) {
            this.effect = effect;
        }

        /**
         * startHour.
         *
         * @return the startHour
         */
        public String getStartHour() {
            return startHour;
        }

        /**
         * startHour.
         *
         * @param startHour the startHour to set
         */
        public void setStartHour(String startHour) {
            this.startHour = startHour;
        }

        /**
         * endHour.
         *
         * @return the endHour
         */
        public String getEndHour() {
            return endHour;
        }

        /**
         * endHour.
         *
         * @param endHour the endHour to set
         */
        public void setEndHour(String endHour) {
            this.endHour = endHour;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }

    }

    /**
     * time.
     *
     * @return the time
     */
    public List<HourDto> getTime() {
        return time;
    }

    /**
     * time.
     *
     * @param time the time to set
     */
    public void setTime(List<HourDto> time) {
        this.time = time;
    }

    /**
     * week.
     *
     * @return the week
     */
    public int getWeek() {
        return week;
    }

    /**
     * week.
     *
     * @param week the week to set
     */
    public void setWeek(int week) {
        this.week = week;
    }

    public ValidPeriodJsonDto(int week, List<HourDto> time) {
        super();
        this.week = week;
        this.time = time;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
