package cn.com.duiba.tuia.core.api.remoteservice.landpage;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.promotetest.AdvertPromoteTestDto;

import java.util.List;

/**
 * 落地页库Remote接口
 *
 * @author zhangbaiqiang
 * @date 2021/3/15
 */
@AdvancedFeignClient
public interface RemoteLandPageRepoService {

    /**
     * 查询落地页列表
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    List<AdvertPromoteTestDto> queryLandPageList(Long advertId);

    /**
     * 添加落地页
     *
     * @param advertPromoteTestDto 落地页参数
     * @return 新增的落地页ID
     */
    Long addLandPage(AdvertPromoteTestDto advertPromoteTestDto) throws BizException;

    /**
     * 删除落地页
     *
     * @param id 落地页Id
     * @return 是否删除成功
     */
    boolean deleteLandPage(Long id) throws BizException;

    /**
     * 查询审核通过的落地页列表
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    List<AdvertPromoteTestDto> queryCheckPassLandPage(Long advertId);

    /**
     * 查询广告主链接相关信息
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    AdvertPromoteTestDto queryMainLandPageInfo(Long advertId);

    /**
     * 查询落地页列表
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    List<AdvertPromoteTestDto> queryAllPromoteTesList(Long advertId);
}
