package cn.com.duiba.tuia.core.api.dto.advert;

import java.io.Serializable;

/**
 * Created by huangch on 2017/11/27 16:23
 * description:
 *
 * @since JDK 1.6
 */
public class AdvertCouponInfoDto implements Serializable {

    private static final long serialVersionUID = -2714271434447862178L;

    //主键id
    private Long id;

    /**
     * 优惠卷id.
     */
    private long advertId;

    /**
     * 推广网址.
     */
    private String promoteURL;

    /**
     * 商品名称.
     */
    private String couponName;

    /**
     * 商品价值(单位为分).
     */
    private Long couponPrice;

    /**
     * 兑换成功文案.
     */
    private String exchangeTips;


    /**
     * 品牌图标.
     */
    private String thumbnailPng;

    /**
     * 首页banner图.
     */
    private String bannerPng;

    /**
     * 领取次数限制.
     */
    private Integer limitReceive;

    /**
     * 优惠码类型.
     */
    private Integer couponType;

    /**
     * 是否隐藏. 对特殊应用隐藏使用按钮(0：否，1：是)
     */
    private boolean displayMenu;

    /**
     * 是否为微信券. 是否为微信券(0：否，1：是) (只有code_type=2 or code_type=3时有效)
     */
    private boolean isWeixin;

    private String buttonText;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(long advertId) {
        this.advertId = advertId;
    }

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Long getCouponPrice() {
        return couponPrice;
    }

    public void setCouponPrice(Long couponPrice) {
        this.couponPrice = couponPrice;
    }

    public String getExchangeTips() {
        return exchangeTips;
    }

    public void setExchangeTips(String exchangeTips) {
        this.exchangeTips = exchangeTips;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public Integer getLimitReceive() {
        return limitReceive;
    }

    public void setLimitReceive(Integer limitReceive) {
        this.limitReceive = limitReceive;
    }

    public Integer getCouponType() {
        return couponType;
    }

    public void setCouponType(Integer couponType) {
        this.couponType = couponType;
    }

    public boolean isDisplayMenu() {
        return displayMenu;
    }

    public void setDisplayMenu(boolean displayMenu) {
        this.displayMenu = displayMenu;
    }

    public boolean isWeixin() {
        return isWeixin;
    }

    public void setWeixin(boolean weixin) {
        isWeixin = weixin;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }
}
