package cn.com.duiba.tuia.core.api.dto.rta;

import lombok.Data;

import java.io.Serializable;

/**
 * @program: tuia-advert-center
 * @description: rat媒体投放广告计划
 * @author: Micheal.Wang
 * @blog: <a href="http://www.micheal.top">MichealWang</a>
 * @create: 2020-04-14 14:37
 **/
@Data
public class RTAAdvertPlanDto implements Serializable {

    private static final long serialVersionUID = 7833894667186047031L;

    /**
     * id
     */
    private Long id;
    /**
     * app名称
     */
    private String appName;
    /**
     * appId
     */
    private Long appId;
    /**
     * 绑定tuia在媒体方开的账号id
     */
    private Long accountId;


    /**
     * 绑定广告名称
     */
    private String advertName;

    /**
     * 外部平台扩展的用于区分同账号的groupid
     * 例如：爱奇艺那边是type
     * 360那边是推广告组id
     */
    private Long extGroupId;

    /**
     * 绑定的广告主名称
     */
    private String advertiserName;
    /**
     * 广告主id
     */
    private Long advertiserId;


    /**
     * 出价方式 CPC/CPM
     */
    private String bidWay;

    /**
     * 出价
     */
    private Long fee;

    /**
     * 1 开启 0关闭
     */
    private Integer openStat;
    /**
     * 1 删除 0未删除
     */
    private Integer delStat;

    /**
     * 屏蔽兴趣标签
     * ，分隔
     */
    private String sheildInterestTags;
    /**
     * 定向兴趣标签。
     * ，分隔
     */
    private String targetedInterestTags;

    /**
     * 刷量配置开关 0 关闭 1开启
     */
    private Long brushSwitch;

    /**
     * 推啊媒体ID
     */
    private Long mediaId;

    /**
     * 推啊媒体appkey
     */
    private String mediaAppKey;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 刷量比例
     */
    private Long brushRate;

    /**
     * 广告ID
     */
    private Long adId;

    /**
     * 广告名字
     */
    private String adName;

    /**
     * 广告状态
     */
    private Long adStatus;

    /**
     * 任务状态
     */
    private Long taskStatus;
    /**
     * dmp人群包过滤开关 0 关闭 1开启
     */
    private Integer dmpCrowdSwitch;
    /**
     * 算法人群包过滤开关 0 关闭 1开启
     */
    private Integer algorithmCrowdSwitch;
    /**
     * 过滤请求次数 默认0
     */
    private Integer requestCountFilter;
    /**
     * 动态出价开关 0 关闭 1开启
     */
    private Integer offerPriceSwitch;
    /**
     * 算法定向兴趣标签
     */
    private String algorithmTargetedInterestTags;
    /**
     * 算法屏蔽兴趣标签
     */
    private String algorithmSheildInterestTags;
}
