package cn.com.duiba.tuia.core.api.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 操作日志登陆类型枚举类
 * @date 2019/10/8 2:46 PM
 */
public enum OperationLogLoginTypeEnum {

    /**
     * 1-manager(管理端)
     */
    MANAGER(1,"管理端"),

    /**
     * 2-advert(广告主端)
     */
    ADVERT(2,"广告主端"),

    JI_MU(3,"积木建站"),
    ;

    private final int code;

    private final String name;

    OperationLogLoginTypeEnum(int code,String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    private static final Map<Integer,String> data = new HashMap<>(4);

    static {
        Stream.of(OperationLogLoginTypeEnum.values()).forEach(temp -> data.put(temp.getCode(),temp.getName()));
    }

    /**
     * 根据登陆类型获取登陆系统名称
     *
     * @param code 登陆码
     * @return 登陆名称
     */
    public static String getNameByCode(Integer code) {
        //这里不需要对code进行非空校验
       return data.get(code);
    }
}
