package cn.com.duiba.tuia.core.api.param;

import lombok.Data;

import java.io.Serializable;

/**
 * @Author yuquanfeng
 * @Date 2021/7/12
 * @Description
 * @Param
 * @return
 **/
@Data
public class UpdateAdvertLinkAuditParam implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 广告id 必填
     */
    private Long advertId;
    /**
     * 审核链接（落地页链接）
     */
    private String auditLink;
    /**
     * 审核资源id（落地页id）非必填
     */
    private Long auditResourceId;
    /**
     * 链接类型 1:广告推广链接;2:定向配置链接;3:AB测试;4:素材绑定落地页测试
     */
    private Integer linkType;
    /**
     * 审核类型 1:落地页审核;2:素材审核 不填默认为 1-落地页审核
     */
    private Integer auditType;
    /**
     * 落地页链接修改动作  0-审核通过 1-删除
     */
    private Integer action;
}
