package cn.com.duiba.tuia.core.api.remoteservice.advert;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.advert.ReqOrientationAdjustCostDto;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.AdjustRatioDto;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.RspOrientationAdjustCostDto;

import java.util.List;

/**
 * Created by MichealWang on 2018/10/30 0030.
 * 广告调价因子 回流数据
 */
@AdvancedFeignClient
public interface RemoteAdvertAdjustService {

    AdjustRatioDto selectAdjustBySubtype(Long advertId, Integer subtype);

    /** 根据advertId 和 appids 查询出签收率*/
    List<AdjustRatioDto> selectAdjustRatios(Long advertId,List<Long> appIds, Integer subtype);

    /** 根据 advertId 配置id查询出 该配置下所有定向媒体 的自定义出价*/
    List<RspOrientationAdjustCostDto> selectOrientationAdjustCosts(Long advertId, Long packageId);

    /** 保存ae修改的 媒体出价*/
    void updateOrientationAdjustCosts(List<ReqOrientationAdjustCostDto> reqs);
}
