package cn.com.duiba.tuia.core.api.remoteservice.adx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdxAdvertMaterialDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.AdxAdvertDspReq;
import cn.com.duiba.tuia.core.api.dto.req.AdxAdvertMaterialReq;
import cn.com.duiba.tuia.core.api.dto.rsp.AdxAdvertDspRsp;

import java.util.List;

/**
 * adx广告素材服务接口
 */
@AdvancedFeignClient
public interface RemoteAdxAdvertMaterialService {


    /**
     * 分页查询adx广告素材列表
     *
     * @param req
     * @return
     */
    PageDto<AdxAdvertMaterialDto> queryPage(AdxAdvertMaterialReq req);

    /**
     * 新增adx广告素材数据
     *
     * @param dto
     * @return
     */
    Integer insert(AdxAdvertMaterialDto dto);

    /**
     * 更新adx广告素材数据
     *
     * @param dto
     * @return
     */
    Integer updateAdxAdvertMaterial(AdxAdvertMaterialDto dto);

    /**
     * 更新adx广告标签数据
     *
     * @param dto
     * @return
     */
    Integer updateTagsById(AdxAdvertMaterialDto dto);

    /**
     * 审核adx广告素材
     *
     * @param dto
     * @return
     */
    Integer updateCheckStatus(AdxAdvertMaterialDto dto);

    /**
     * 逻辑删除adx广告素材
     *
     * @param dto
     * @return
     */
    Integer deleteAdxAdvertMaterial(AdxAdvertMaterialDto dto);

    /**
     * 查询adx广告素材列表,最多1000条
     *
     * @param req
     * @return
     */
    List<AdxAdvertDspRsp> dspGetAdxInfo(AdxAdvertDspReq req);

    /**
     * 根据条件查询adx广告素材数量
     *
     * @param req
     * @return
     */
    Integer getCountByParam(AdxAdvertMaterialReq req);


}
