package cn.com.duiba.tuia.core.api.remoteservice.flowback;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.flowback.DataFlowbackPlanDTO;
import cn.com.duiba.tuia.core.api.dto.flowback.PlanPageQueryConditionsDTO;
import cn.com.duiba.tuia.core.api.vo.DataFlowbackPlanVO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAutoFlowbackPlanService {

    /**
     * 根据条件查询 符合的自动回流计划条数
     * @param req
     * @return
     */
    Long countQueryByConditions(PlanPageQueryConditionsDTO req);

    /**
     *
     * 根据条件 分页查询自动回流计划
     * @param req
     * @return
     */
    List<DataFlowbackPlanVO> queryByConditions(PlanPageQueryConditionsDTO req);

    /**
     * 添加或编辑 自动回流计划
     * @param dto
     * @return
     */
    Boolean addOrUpdPlan(DataFlowbackPlanDTO dto) throws BizException;


    /**
     * 滑动开关
     * @param planId
     * @param switchStatus
     * @return
     */
    Boolean switchStatus(Long planId, String switchStatus) throws BizException;

    /**
     * 定时任务 更新所有状态
     * @return
     */
    Boolean doRefreshStatus();

}
