package cn.com.duiba.tuia.core.api.remoteservice.risk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.risk.AdvertAuditPlatformDto;
import cn.com.duiba.tuia.core.api.dto.risk.AdvertBaseRiskInfoDto;
import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;

import java.util.List;

/**
 * 提供给风控审核中心
 */
@AdvancedFeignClient
public interface RemoteRiskAuditPlatformService {


    /**
     * 查询广告平台 待审核的广告主账号，广告主资质，广告计划，落地页，素材 数量
     * @return
     */
    AdvertAuditPlatformDto queryAdvertWaitAuditInfo();

    /**
     * 分页 查询待审核的广告计划 详情（默认 按照待审时长倒序；也可以按照广告主名称倒序）
     */

    List<AdvertBaseRiskInfoDto> queryWatitAuditAdvertInfo(BaseQueryReq baseQueryReq);

    /**
     * 分页 查询待审核的广告计划 详情 总数
     */
    Integer queryWaitAuditAdvertInfoCount(BaseQueryReq baseQueryReq);
}
