package cn.com.duiba.tuia.core.api.dto.data;

import cn.com.duiba.tuia.core.api.enums.advert.AssessTypeEnum;

import java.io.Serializable;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: UploadDateByOneLine
 * Function:后端回传数据 实体
 * Date:     2019/3/8 0008 上午 10:49
 */
public class UploadDateByOneLineDto implements Serializable {

    private static final long serialVersionUID = -3522625878072996506L;
    /** 广告id*/
    private Long advertId;

    /** 考核指标
     * 对应关系参见{@link AssessTypeEnum}
     * */
    private Integer assessmentIndex;

    /**
     * 当前日期
     */
    private String curDate;

    /***
     * 推广链接
     */
    private String promoteUrl;

    /** 上传的考核转化数*/
    private Long assessmentNum;

    public UploadDateByOneLineDto() {
    }

    public UploadDateByOneLineDto(Long advertId, Integer assessmentIndex, String curDate, String promoteUrl, Long assessmentNum) {
        this.advertId = advertId;
        this.assessmentIndex = assessmentIndex;
        this.curDate = curDate;
        this.promoteUrl = promoteUrl;
        this.assessmentNum = assessmentNum;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Integer getAssessmentIndex() {
        return assessmentIndex;
    }

    public void setAssessmentIndex(Integer assessmentIndex) {
        this.assessmentIndex = assessmentIndex;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public Long getAssessmentNum() {
        return assessmentNum;
    }

    public void setAssessmentNum(Long assessmentNum) {
        this.assessmentNum = assessmentNum;
    }
}
