package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialAdxDirectDto;

import java.util.List;

/**
 *  adx 广告主审核
 */
@AdvancedFeignClient
public interface RemoteAdxAccountAuditService {

    /**
     * adx 广告主送审
     */
    void sendAdxAccountAudit(Long accountId, List<Long> adxTypes, Integer senceType,List<Long> materialIds);


    /**
     * 调用接口查询当前广告主的审核状态
     */
    List<AdvertMaterialAdxDirectDto> queryAccountAuditStatus(Long accountId, List<Integer> adxTypes) throws BizException;

}
