package cn.com.duiba.tuia.core.api.remoteservice.landpage;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.promotetest.AdvertPromoteTestDto;

import java.util.List;

/**
 * 落地页库Remote接口
 *
 * @author zhangbaiqiang
 * @date 2021/3/15
 */
@AdvancedFeignClient
public interface RemoteLandPageRepoService {

    /**
     * 查询落地页列表
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    List<AdvertPromoteTestDto> queryLandPageList(Long advertId);

    /**
     * 添加落地页
     *
     * @param advertPromoteTestDto 落地页参数
     * @return 新增的落地页ID
     */
    Long addLandPage(AdvertPromoteTestDto advertPromoteTestDto) throws BizException;

    /**
     * 删除落地页
     *
     * @param id 落地页Id
     * @return 是否删除成功
     */
    boolean deleteLandPage(Long id) throws BizException;

    /**
     * 查询审核通过的落地页列表
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    List<AdvertPromoteTestDto> queryCheckPassLandPage(Long advertId);

    /**
     * 查询广告主链接相关信息
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    AdvertPromoteTestDto queryMainLandPageInfo(Long advertId);

    /**
     * 查询落地页列表
     *
     * @param advertId 广告Id
     * @return 落地页列表
     */
    List<AdvertPromoteTestDto> queryAllPromoteTesList(Long advertId);



    /**
     * 落地页重新送审(进入待审核的流程)
     * 主链接是广告进入待审核流程
     * 其他链接是落地页进入待审核流程
     * @author fanjia
     * @date 2022/4/8 下午1:58
     * @param promoteId 落地页id   主链接原则上是没有落地页id的.在落地页库里展示出来的id 其实是广告的id
     * @param advertId 广告id
     * @param isMainPromote  是否是主链接
     * @return java.lang.Boolean
     */
    Boolean againEnterReview(Long promoteId, Long advertId, Boolean isMainPromote) throws BizException;
}
