package cn.com.duiba.tuia.core.api.remoteservice.layered;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.layered.LayeredStrategyDto;
import cn.com.duiba.tuia.core.api.dto.req.layered.LayeredStrategyQuery;

import java.util.List;

/**
 * [广告分媒体调控]Remote接口
 *
 * @author zhangbaiqiang
 * @date 2020/7/23
 */
@AdvancedFeignClient
public interface RemoteLayeredStrategyService {

    /**
     * 查询策略数量
     */
    int count(LayeredStrategyQuery query);

    /**
     * 查询策略列表
     */
    List<LayeredStrategyDto> list(LayeredStrategyQuery query);

    /**
     * 查询策略详细
     */
    LayeredStrategyDto queryById(Long strategyId);

    /**
     * 新建策略
     */
    Long add(LayeredStrategyDto strategyDto) throws BizException;

    /**
     * 更新策略
     */
    Boolean update(LayeredStrategyDto strategyDto) throws BizException;

    /**
     * 更新策略状态
     */
    Boolean toggleStatus(LayeredStrategyDto strategyDto) throws BizException;
}
