/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteQualificationAuditService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.qualification
 * Date:2017年12月1日上午9:59:03
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.remoteservice.qualification;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.QueryDto;
import cn.com.duiba.tuia.core.api.dto.req.advert.AdvertNewTradeReq;
import cn.com.duiba.tuia.core.api.dto.req.advert.AdvertQualificationReq;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqPageQualificationAuditDto;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqQualificationAuditDto;
import cn.com.duiba.tuia.core.api.dto.req.qualification.ReqeQualificationDetail;
import cn.com.duiba.tuia.core.api.dto.rsp.account.CleanQualificationAuditDto;
import cn.com.duiba.tuia.core.api.dto.rsp.account.QualificationAuditDto;
import cn.com.duiba.tuia.core.api.dto.rsp.account.QualificationSimpleAuditDto;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.AdvertInfoDto;
import cn.com.duiba.tuia.core.api.dto.rsp.qualification.RespQualificationCreateDto;
import cn.com.duiba.tuia.core.api.enums.QualificationCheckEnum;

import java.util.List;
import java.util.Set;

/**
 * ClassName:RemoteQualificationAuditService <br/>
 * Function: 资质审核信息接口. <br/>
 * Date:     2017年12月1日 上午9:59:03 <br/>
 *
 * @author chencheng
 * @see
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteQualificationAuditService {

    /**
     * selectQualificationAudit:(条件查询资质审核信息). <br/>
     *
     * @param query 查询条件
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    List<QualificationAuditDto> selectQualificationAudit(ReqPageQualificationAuditDto query);

    /**
     * selectQualificationAudit:(条件查询所有的资质审核信息数量). <br/>
     *
     * @param query 查询条件
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    Integer selectQualificationAuditCount(ReqPageQualificationAuditDto query);

    /**
     * updateQualificationAuditBatch:(批量操作资质审核信息). <br/>
     *
     * @param listDto 资质审核信息List
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    Integer batchModifyQualificationAudit(List<ReqQualificationAuditDto> listDto);

    /**
     * updateQualificationAudit:(修改资质审核信息). <br/>
     *
     * @param query
     * @return
     * @author chencheng
     * @since JDK 1.8
     */
    Integer updateQualificationAudit(ReqQualificationAuditDto query);

    /**
     * 根据广告主维度分页查询资质审核数据数量
     *
     * @param query
     * @return
     */
    Integer getQualificationAuditGroupAccountCount(ReqPageQualificationAuditDto query);

    /**
     * 根据广告主维度分页查询资质审核数据
     *
     * @param query
     * @return
     */
    List<QualificationAuditDto> getQualificationAuditGroupAccount(ReqPageQualificationAuditDto query);

    /**
     * 根据广告主id 查询广告主的资质详情信息
     *
     * @param accountId
     * @return
     */
    ReqeQualificationDetail accountQualificationDetail(Long accountId);

    /**
     * 根据资质id列表 查询广告主的资质信息
     *
     * @param qualificationIds
     * @return
     */
    List<QualificationAuditDto> getQualificationListByIds(List<Long> qualificationIds);

    /**
     * 根据条件获取要导出的数据
     *
     * @param query
     * @return
     */
    List<QualificationAuditDto> getQualificationForExpert(ReqPageQualificationAuditDto query);

    /**
     * 根据广告主id和审核状态 查询资质id列表信息
     *
     * @param accountId
     * @param checkStatus
     * @return
     */
    List<Long> getIdsByAccount(Long accountId, Integer checkStatus);

    /**
     * 根据广告主ID和资质审核状态查询数据
     *
     * @param accountId
     * @param checkEnum
     * @return
     */
    QualificationSimpleAuditDto getSimpleQualificationListByAcIdCheck(Long accountId, QualificationCheckEnum checkEnum);

    /**
     * 获取广告主已经提交资质的行业ID集合
     *
     * @param accountId 广告主id
     * @return 行业ID集合
     */
    Set<Long> getAuditTradeIdsByAccount(Long accountId);

    /**
     * 根据广告主id集合查询资质名称
     * @param list
     * @return
     */
    List<String> getQualificationNames(List<Long> list);

    /**
     * 检查是否包含停用的行业
     *
     * @param qualificationIds 资质id列表
     * @return true.包含停用的行业, false.不包含
     */
    Boolean checkDisableTrade(List<Long> qualificationIds);

    /**
     * 获取需要添加水印的存量数据量
     *
     * @return
     */
    Integer getCleanApplicationAuditCount();

    /**
     * 获取需要添加水印的数据
     *
     * @param dto
     * @return
     */
    List<CleanQualificationAuditDto> getCleanApplicationAuditList(QueryDto dto);

    /**
     * 获取广告主资质
     *
     * @param list
     * @return
     */
    List<RespQualificationCreateDto> getQualificationAuditList(List<Long> list, String qualificationName);

    /**
     * 批量存储广告主资质详情
     *
     * @param listQuery
     * @return
     */
    Integer batchUpdateQualificationAudit(List<ReqQualificationAuditDto> listQuery);

    List<AdvertInfoDto> getAdvertByAdsAeSellTrade(AdvertQualificationReq req);

    /**
     * 广告主是否有所属的行业所有必须的资质
     *
     * @param accountId 广告主id
     * @return 行业ID集合
     */
    Boolean advertiserHaveTradeNeed(Long accountId);

    /**
     * 广告主是否有资质要求：《代理商合作证明》
     *
     * @param accountId 广告主id
     */
    Boolean advertiserHaveKyc(Long accountId);
}

