package cn.com.duiba.tuia.core.api.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.joda.time.DateTime;

import com.google.common.collect.Lists;

/**
 * Created by huangch on 2017/12/15 18:03
 * description:
 *
 * @since JDK 1.6
 */
public class TimeUtil {

    private static final List<String> weeks = Lists.newArrayList("周一", "周二", "周三", "周四", "周五", "周六", "周日");

    /**
     * 获取当前日期的周数
     *
     * @return 周数
     */
    public static String getWeek() {
        Calendar now = Calendar.getInstance();
        // 一周第一天是否为星期天
        boolean isFirstSunday = (now.getFirstDayOfWeek() == Calendar.SUNDAY);
        // 获取周几
        int weekDay = now.get(Calendar.DAY_OF_WEEK);
        // 若一周第一天为星期天，则-1
        if(isFirstSunday){
            weekDay = weekDay - 1;
            if(weekDay == 0){
                weekDay = 7;
            }
        }

        return weeks.get(weekDay - 1);
    }

    public static List<Integer> getMonthBetween(Date minDate, Date maxDate) {
        List<Integer> result = Lists.newArrayList();

        DateTime maxDateTime = new DateTime(maxDate);
        DateTime curDateTime = new DateTime(minDate);

        //防止死循环
        int maxForEachCount = 0;

        while (curDateTime.compareTo(maxDateTime) < 0 && maxForEachCount < 100) {
            result.add(curDateTime.getMonthOfYear());
            curDateTime = curDateTime.plusMonths(1);
            maxForEachCount++;
        }

        return result;
    }
}
