/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertMaterialDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月21日下午2:11:03<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 广告素材DTO <br/>
 * date: 2016年12月21日 下午2:11:03 <br/>
 * .
 *
 * @author xuxx
 * @since JDK 1.8
 */
public class AdvertMaterialTestPlanDto extends BaseDto {

    /**
     * The Constant serialVersionUID. @since JDK 1.7
     */
    private static final long serialVersionUID = -3596705396272567507L;

    public static final Integer EnableStateClose = 0;
    public static final Integer EnableStateOpen = 1;

    /**
     * 广告ID.
     */
    private Long advertId;

    /**
     * 配置id列表，以","分割
     */
    private String orientIds;

    /**
     * 激活状态(0：屏蔽， 1：激活).
     */
    private Integer enableState;

    private Integer testFlowRatio;

    /**
     * 开始时间.
     */
    private String startime;

    /**
     * 结束时间.
     */
    private String endtime;

    /**
     * 素材id，查询时使用
     */
    private List<Long> materialIds;

    /**
     * 测试素材列表 ,返回时使用
     */
    private List<AdvertMaterialDto> materialDtos;

    /**
     * 测试素材Id->自定义测试比例
     */
    private Map<Long, Integer> testInfoMap;

    /**
     * 是否开启自定义分流 0/null 未开启，1开启
     */
    private Integer isCustom;

    public Map<Long, Integer> getTestInfoMap() {
        return testInfoMap;
    }

    public void setTestInfoMap(Map<Long, Integer> testInfoMap) {
        this.testInfoMap = testInfoMap;
    }

    public Integer getIsCustom() {
        return isCustom;
    }

    public void setIsCustom(Integer isCustom) {
        this.isCustom = isCustom;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getOrientIds() {
        return orientIds;
    }

    public void setOrientIds(String orientIds) {
        this.orientIds = orientIds;
    }

    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }

    public Integer getTestFlowRatio() {
        return testFlowRatio;
    }

    public void setTestFlowRatio(Integer testFlowRatio) {
        this.testFlowRatio = testFlowRatio;
    }

    public String getStartime() {
        return startime;
    }

    public void setStartime(String startime) {
        this.startime = startime;
    }

    public String getEndtime() {
        return endtime;
    }

    public void setEndtime(String endtime) {
        this.endtime = endtime;
    }

    public List<Long> getMaterialIds() {
        return materialIds;
    }

    public void setMaterialIds(List<Long> materialIds) {
        this.materialIds = materialIds;
    }

    public List<AdvertMaterialDto> getMaterialDtos() {
        return materialDtos;
    }

    public void setMaterialDtos(List<AdvertMaterialDto> materialDtos) {
        this.materialDtos = materialDtos;
    }
}
