package cn.com.duiba.tuia.core.api.dto.advert;

import java.io.Serializable;
import java.util.List;

/**
 * Created by huangch on 2019/1/29 17:23
 * description:
 *
 * @since JDK 1.6
 */
public class OrientationFocusAppConvertCostDto implements Serializable {

    private static final long serialVersionUID = 1465707591134829488L;

    private Long id;

    private Long advertId;

    private Long orientationId;

    /** 配置id 集合*/
    private List<Long> orientationIds;

    private Long appId;

    /** 优化目标 @AdvertSubtypeEnum */
    private Integer subtype;

    /** 出价,媒体转化出价或广告cpc出价 */
    private Long    convertCost;

    /** 包的类型 1-人工包，2-系统托管包 */
    private Integer packageType;

    /** 计费方式,当前仅有：1.CPC;2.CPA @ChargeTypeEnum */
    private Integer chargeType;

    /** 投放目标类型，1-稳定投放，2-抢量优先(中)， 3-抢量优先(高)， 4-人工定向， 5-成本优先 @PutTargetTypeEnum */
    private Integer putTargetType;

    /** 是否开启潜力广告扶持，0-否、1-是 */
    private Integer potentialType;
    
    /** 单媒体成本维稳开关，0：关，表示用配置维稳，1：开启 */
    private Integer           appCostStableSwitch;

    /** 媒体来源*/
    private Integer appSource;

    public List<Long> getOrientationIds() {
        return orientationIds;
    }

    public OrientationFocusAppConvertCostDto setOrientationIds(List<Long> orientationIds) {
        this.orientationIds = orientationIds;
        return this;
    }

    /**
     * appCostStableSwitch.
     *
     * @return the appCostStableSwitch
     * @since JDK 1.8
     */
    public Integer getAppCostStableSwitch() {
        return appCostStableSwitch;
    }

    /**
     * appCostStableSwitch.
     *
     * @param appCostStableSwitch the appCostStableSwitch to set
     * @since JDK 1.8
     */
    public void setAppCostStableSwitch(Integer appCostStableSwitch) {
        this.appCostStableSwitch = appCostStableSwitch;
    }

    /**
     * packageType.
     *
     * @return the packageType
     * @since JDK 1.8
     */
    public Integer getPackageType() {
        return packageType;
    }

    /**
     * packageType.
     *
     * @param packageType the packageType to set
     * @since JDK 1.8
     */
    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    /**
     * chargeType.
     *
     * @return the chargeType
     * @since JDK 1.8
     */
    public Integer getChargeType() {
        return chargeType;
    }

    /**
     * chargeType.
     *
     * @param chargeType the chargeType to set
     * @since JDK 1.8
     */
    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    /**
     * putTargetType.
     *
     * @return the putTargetType
     * @since JDK 1.8
     */
    public Integer getPutTargetType() {
        return putTargetType;
    }

    /**
     * putTargetType.
     *
     * @param putTargetType the putTargetType to set
     * @since JDK 1.8
     */
    public void setPutTargetType(Integer putTargetType) {
        this.putTargetType = putTargetType;
    }

    /**
     * potentialType.
     *
     * @return the potentialType
     * @since JDK 1.8
     */
    public Integer getPotentialType() {
        return potentialType;
    }

    /**
     * potentialType.
     *
     * @param potentialType the potentialType to set
     * @since JDK 1.8
     */
    public void setPotentialType(Integer potentialType) {
        this.potentialType = potentialType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrientationId() {
        return orientationId;
    }

    public void setOrientationId(Long orientationId) {
        this.orientationId = orientationId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getSubtype() {
        return subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public Long getConvertCost() {
        return convertCost;
    }

    public void setConvertCost(Long convertCost) {
        this.convertCost = convertCost;
    }

    public Integer getAppSource() {
        return appSource;
    }

    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }
}
