package cn.com.duiba.tuia.core.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("dsp查询adx广告对象")
public class AdxAdvertDspReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "dspId不可为空")
    @ApiModelProperty("DSP平台标识")
    private Long dspId;

    @NotNull(message = "秘钥不可为空")
    @ApiModelProperty("秘钥用于token的校验")
    private String signature;

    @ApiModelProperty("adx广告id")
    private Long advertId;

    @ApiModelProperty("默认为通过,审核状态,0-审核中;1-审核通过;2-审核拒绝")
    private Integer checkStatus;

    public Long getDspId() {
        return dspId;
    }

    public void setDspId(Long dspId) {
        this.dspId = dspId;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
}
