package cn.com.duiba.tuia.core.api.enums.reflow;

/**
 * @author Wangpf
 * @description
 * @date 2021/11/24 4:10 下午
 * <p>
 * /**
 * * 计划状态
 * *
 * * 1-刷量中
 * * 2-未配置
 * * 3-已暂停
 * * 4-预算不足
 * * 5-计划暂停
 * * 6-计划未找到
 * * 7-系统异常（错误码）
 * * 8-接口异常
 * * 9-未知错误
 */

public enum ReflowPlanStatusEnum {

    REFLOW_ING(1, "刷量中"),

    NOT_CONFIG(2, "未配置"),

    REFLOW_PAUSE(3, "已暂停"),

    NOT_ENOUGH_BUDGET(4, "预算不足"),

    ADVERT_PAUSE(5, "计划暂停"),

    ADVERT_NOT_FOUND(6, "计划未找到"),

    SYSTEM_ERROR(7, "系统异常"),

    INTERFACE_ERROR(8, "接口异常"),

    UNKNOWN_ERROR(9, "未知错误");

    private final Integer planStatus;

    private final String desc;

    ReflowPlanStatusEnum(Integer planStatus, String desc) {
        this.planStatus = planStatus;
        this.desc = desc;
    }

    public Integer getPlanStatus() {
        return planStatus;
    }

    public String getDesc() {
        return desc;
    }
}
