package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertConsumeExceptionDto;
import cn.com.duiba.tuia.core.api.dto.DiagnoseExceptionRequest;

import java.util.List;

/**
 * @author zhangmeng
 * @date 2019/6/12
 * @function
 */
@AdvancedFeignClient
public interface RemoteDiagnoseExceptionService {

    /**
     * 通过条件查询 消耗异常数据
     * @param diagnoseExceptionRequest
     * @return
     */
    List<AdvertConsumeExceptionDto> getConsumeExceptionDetail(DiagnoseExceptionRequest diagnoseExceptionRequest);

    /**
     * 通过广告id,查询当前广告是否存在消耗异常数据
     */
    AdvertConsumeExceptionDto getConsumeExceptionByAdvertId(Long advertId);

    /**
     * 查询总数
     * @param diagnoseExceptionRequest
     * @return
     */
    Integer getConsumeExceptionDetailCount(DiagnoseExceptionRequest diagnoseExceptionRequest);
}
