package cn.com.duiba.tuia.core.api.remoteservice.rta;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AccountDto;
import cn.com.duiba.tuia.core.api.dto.rta.*;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteRTAService {

    // 批量查询
     List<RTAAdvertPlanDto> query(RTAQueryReqDto dto);

    // 新增或者修改
     void addOrUpdate(RTAAdvertPlanDto dto) throws BizException;

    //开关
     void updateStatus(Integer status,Long id);

     //删除
     void delete(Long id);

    //模糊查询广告主
     List<AccountDto> getAllAdvertiser(String advertiserName);

     // RTA媒体映射关系查询
     List<RTAAppMappingDto> getAllRTAAppMapping();

    // RTA媒体映射关系新增
     void addRTAAppMapping(RTAAppMappingDto dto) throws BizException;

    // RTA媒体映射关系开关
     void updateRTAAppMappingStatus(Integer status,Long id);

     //删除
     void deleteRTAAppMapping(Long id);

    //获取rta媒体和渠道id映射关系
    List<RTAAppDto> getAppMappigChannelId();

    //根据id获取绑定的appid
    Long getAppIdById(Long id);

    List<RTAAdvertDto> advertQuery(Long advertId);

    AutoFlowBackTaskInfoDto getTaskInfo(AutoFlowBackTaskInfoDto dto);

    List<RTAAdvertPlanDto> queryByAppId(Long appId);

    List<RTAAdvertiserDto> queryAccountIds(Set<Long> accountIds);

    List<Long> queryAccountIdsByAppId(Long appId);
}
