/**
 * Project Name:tuia-advert-center-api File Name:RemoteNewTagService.java Package
 * Name:cn.com.duiba.tuia.core.api.remoteservice.tag Date:2018年1月15日下午1:51:31 Copyright (c) 2018, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.remoteservice.tag;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.tag.ReqNewTagDto;
import cn.com.duiba.tuia.core.api.dto.rsp.tag.NewTagDto;
import cn.com.duiba.tuia.core.api.dto.rsp.tag.NewTagLevelDto;

/**
 * ClassName:RemoteNewTagService <br/>
 * Function: 新标签库操作接口. <br/>
 * Date: 2018年1月15日 下午1:51:31 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
@AdvancedFeignClient
public interface RemoteNewTagService {

    /**
     * insertNewTag:(新增). <br/>
     *
     * @author chencheng
     * @param newTagDto 新标签dto
     * @return
     * @since JDK 1.8
     */
    Integer insertNewTag(NewTagDto newTagDto);

    /**
     * selectNewTagByTagNum:(根据tagNum查询标签详情). <br/>
     * 
     * @author chencheng
     * @param tagNum 标签tagNum
     * @return
     * @since JDK 1.8
     */
    NewTagDto selectNewTagByTagNum(String tagNum);

    /**
     * selectAllNewTagByTagNumList:(获取所有标签的层级关系). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    List<NewTagLevelDto> selectAllNewTagByTagNumList();

    /**
     * selectNewTagByTagNum:(根据tagNum查询标签详情). <br/>
     * 
     * @author chencheng
     * @param tagNums 多个标签tagNum
     * @return
     * @since JDK 1.8
     */
    List<NewTagDto> selectNewTagByTagNumList(List<String> tagNums);

    /**
     * selectNewTagList:(批量查询标签详情，参数可为空标示查询全部). <br/>
     *
     * @author chencheng
     * @param req 新标签查询req
     * @return
     * @since JDK 1.8
     */
    List<NewTagDto> selectNewTagList(ReqNewTagDto req);

    /**
     * selectNewMaxTagNum:(根据父标签id,子标签级别查询最大子级标签编码 ). <br/>
     *
     * @author chencheng
     * @param parentTagNum 父标签tagNum
     * @param tagLevel 子标签级别
     * @return
     * @since JDK 1.8
     */
    String selectNewMaxTagNum(Integer tagLevel, String parentTagNum);

    /**
     * selectDuplicationTagName:(查询父级标签下标签是否重名). <br/>
     *
     * @author chencheng
     * @param tagName 标签名称
     * @param parentTagNum 父标签tagNum
     * @return
     * @since JDK 1.8
     */
    List<NewTagDto> selectDuplicationNewTagName(String tagName, String parentTagNum);

    /**
     * batchUpdateNewTag:(批量更新). <br/>
     *
     * @author chencheng
     * @param req 新标签查询req
     * @return
     * @since JDK 1.8
     */
    Integer batchUpdateNewTag(List<NewTagDto> req);

    /**
     * selectNewTagNumsByName:(根据标签名称查询一二级标签tagnum列表，用于页面标签定位). <br/>
     *
     * @author chencheng
     * @param tagName 一二级标签名称
     * @return
     * @since JDK 1.8
     */
    List<String> selectNewTagNumsByName(String tagName);

    /**
     * selectNewTagListGroupByName:(模糊查询所有匹配的一二级标签(根据标签名去重)，用于页面标签定位.). <br/>
     *
     * @author chencheng
     * @param tagName 一二级标签名称
     * @return
     * @since JDK 1.8
     */
    List<NewTagDto> selectNewTagListGroupByName(String tagName);


    /**
     * 查询名称为落地页动效的标签库.
     *
     * @return NewTagLevelDto
     */
    NewTagLevelDto  getTagDynamicEffectLibrary();
    /**
     * 查询名称为程序自动化打标的标签库.
     *
     * @return  NewTagLevelDto
     */
    NewTagLevelDto  getAutoMakeTag();

    /**
     * 查询名称为程序自动化打标的标签 里的多表单.
     *
     * @return  NewTagLevelDto
     */
    NewTagLevelDto  getAutoMakeTagMoreTable();
}
