/**
 * Project Name:manager-domain<br>
 * File Name:AdvertStatisticsData.java<br>
 * Package Name:cn.com.duiba.tuia.manager.model<br>
 * Date:2016年5月24日下午2:10:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * ClassName:AdvertStatisticsData <br/>
 * Function: 广告统计数据(发券量、曝光量、点击数、计费点击、点击UV、点击率、花费、点击均价). <br/>
 * Reason: . <br/>
 * Date: 2016年5月24日 下午2:10:36 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class AdvertStatisticsData implements Serializable {

    private static final long serialVersionUID = -5959828724539396651L;
    /** 广告id */
    private Long              advertId;
    private Long accountId;
    /** 发券量. */
    @ApiModelProperty(value = "发券量")
    private Long              launchCount;

    /** 曝光量. */
    @ApiModelProperty(value = "曝光量")
    private Long              exposureCount;

    /** 点击数. */
    @ApiModelProperty(value = "点击数")
    private Long              clickCount;

    /** 有效点击. */
    @ApiModelProperty(value = "有效点击")
    private Long              efClickCount;

    /** 点击率. CTR */
    @ApiModelProperty(value = "点击率 CTR")
    private Float             clickRate;

    /** 花费. */
    @ApiModelProperty(value = "花费")
    private Long              consumeTotal;

    @ApiModelProperty(value = "作弊消耗")
    private Long              cheatConsume;

    /** 点击均价. */
    @ApiModelProperty(value = "点击均价")
    private Integer           averagePrice;

    /** 点击UV. */
    @ApiModelProperty(value = "点击UV")
    private Long              clickUV;

    /** 落地页访问pv */
    @ApiModelProperty(value = "落地页访问pv")
    private Long              visitPv;

    /** 落地页效果pv */
    @ApiModelProperty(value = "落地页效果pv")
    private Long              effectPv;

    /** 落地页访问uv */
    @ApiModelProperty(value = "落地页访问uv")
    private Long              visitUv;

    /** 落地页效果uv */
    @ApiModelProperty(value = "落地页效果uv")
    private Long              effectUv;

    /** 转化成本（PV）消耗/转化pv */
    @ApiModelProperty(value = "转化成本（PV）消耗/转化pv")
    private String            effectCost;
    
    /** 落地页损耗（落地页访问 PV / 计费点击） */
    @ApiModelProperty(value = "落地页损耗")
    private Float             loss;

    /** CVR（转化PV / 计费点击） */
    @ApiModelProperty(value = "CVR")
    private Float             cvr;

    @ApiModelProperty(value = "成本")
    private Double cost;

    /** js的计费点击 */
    @ApiModelProperty(value = "js的计费点击")
    private Long              jsEffectClickCount;

    /** 启动PV */
    @ApiModelProperty(value = "启动PV")
    private Long              startPv;

    /** 启动成本 */
    @ApiModelProperty(value = "启动成本")
    private String              startCost;

    /** 启动CVR */
    @ApiModelProperty(value = "启动CVR")
    private Float              startCvr;

    /** 注册PV */
    @ApiModelProperty(value = "注册PV")
    private Long              registePv;

    /** 注册成本 */
    @ApiModelProperty(value = "注册成本")
    private String              registeCost;

    /** 注册CVR */
    @ApiModelProperty(value = "注册CVR")
    private Float              registeCvr;

    @ApiModelProperty("上级代理商ID")
    private Long agentId;

    @ApiModelProperty("付费成本")
    private String payCost;

    @ApiModelProperty("付费cvr")
    private Float payCvr;

    @ApiModelProperty("进件成本")
    private String entryCost;

    @ApiModelProperty("进件cvr")
    private Float entryCvr;

    @ApiModelProperty("完件成本")
    private String finishCost;

    @ApiModelProperty("完件cvr")
    private Float finishCvr;

    @ApiModelProperty("用户付费pv")
    private Long payPv;

    @ApiModelProperty("用户进件pv")
    private Long entryPv;

    @ApiModelProperty("用户完件pv")
    private Long finishPv;

    @ApiModelProperty("用户付费uv")
    private Long payUv;

    @ApiModelProperty("用户进件uv")
    private Long entryUv;

    @ApiModelProperty("用户完件uv")
    private Long finishUv;

    public Long getPayUv() {
        return payUv;
    }

    public void setPayUv(Long payUv) {
        this.payUv = payUv;
    }

    public Long getEntryUv() {
        return entryUv;
    }

    public void setEntryUv(Long entryUv) {
        this.entryUv = entryUv;
    }

    public Long getFinishUv() {
        return finishUv;
    }

    public void setFinishUv(Long finishUv) {
        this.finishUv = finishUv;
    }

    public Long getPayPv() {
        return payPv;
    }

    public void setPayPv(Long payPv) {
        this.payPv = payPv;
    }

    public Long getEntryPv() {
        return entryPv;
    }

    public void setEntryPv(Long entryPv) {
        this.entryPv = entryPv;
    }

    public Long getFinishPv() {
        return finishPv;
    }

    public void setFinishPv(Long finishPv) {
        this.finishPv = finishPv;
    }

    public Long getAgentId() { return agentId; }

    public void setAgentId(Long agentId) { this.agentId = agentId; }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Double getCost() {
        return cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public Long getCheatConsume() {
        return cheatConsume;
    }

    public void setCheatConsume(Long cheatConsume) {
        this.cheatConsume = cheatConsume;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getJsEffectClickCount() {
        return jsEffectClickCount;
    }

    public void setJsEffectClickCount(Long jsEffectClickCount) {
        this.jsEffectClickCount = jsEffectClickCount;
    }

    /**
     * visitUv.
     *
     * @return the visitUv
     */
    public Long getVisitUv() {
        return visitUv;
    }

    /**
     * visitUv.
     *
     * @param visitUv the visitUv to set
     */
    public void setVisitUv(Long visitUv) {
        this.visitUv = visitUv;
    }

    /**
     * effectUv.
     *
     * @return the effectUv
     */
    public Long getEffectUv() {
        return effectUv;
    }

    /**
     * effectUv.
     *
     * @param effectUv the effectUv to set
     */
    public void setEffectUv(Long effectUv) {
        this.effectUv = effectUv;
    }

    /**
     * visitPv.
     *
     * @return the visitPv
     */
    public Long getVisitPv() {
        return visitPv;
    }

    /**
     * visitPv.
     *
     * @param visitPv the visitPv to set
     */
    public void setVisitPv(Long visitPv) {
        this.visitPv = visitPv;
    }

    /**
     * effectPv.
     *
     * @return the effectPv
     */
    public Long getEffectPv() {
        return effectPv;
    }

    /**
     * effectPv.
     *
     * @param effectPv the effectPv to set
     */
    public void setEffectPv(Long effectPv) {
        this.effectPv = effectPv;
    }

    /**
     * loss.
     *
     * @return the loss
     */
    public Float getLoss() {
        return loss;
    }

    /**
     * loss.
     *
     * @param loss the loss to set
     */
    public void setLoss(Float loss) {
        this.loss = loss;
    }

    /**
     * cvr.
     *
     * @return the cvr
     */
    public Float getCvr() {
        return cvr;
    }

    /**
     * cvr.
     *
     * @param cvr the cvr to set
     */
    public void setCvr(Float cvr) {
        this.cvr = cvr;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Long getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * clickRate.
     *
     * @return the clickRate
     * @since JDK 1.6
     */
    public Float getClickRate() {
        return clickRate;
    }

    /**
     * clickRate.
     *
     * @param clickRate the clickRate to set
     * @since JDK 1.6
     */
    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * averagePrice.
     *
     * @return the averagePrice
     * @since JDK 1.6
     */
    public Integer getAveragePrice() {
        return averagePrice;
    }

    /**
     * averagePrice.
     *
     * @param averagePrice the averagePrice to set
     * @since JDK 1.6
     */
    public void setAveragePrice(Integer averagePrice) {
        this.averagePrice = averagePrice;
    }

    /**
     * Gets the click uv.
     *
     * @return the click uv
     */
    public Long getClickUV() {
        return clickUV;
    }

    /**
     * Sets the click uv.
     *
     * @param clickUV the click uv
     */
    public void setClickUV(Long clickUV) {
        this.clickUV = clickUV;
    }



    
    /**
     * effectCost.
     *
     * @return  the effectCost
     * @since   JDK 1.8
     */
    public String getEffectCost() {
        return effectCost;
    }

    
    /**
     * effectCost.
     *
     * @param   effectCost    the effectCost to set
     * @since   JDK 1.8
     */
    public void setEffectCost(String effectCost) {
        this.effectCost = effectCost;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Long getStartPv() {
        return startPv;
    }

    public void setStartPv(Long startPv) {
        this.startPv = startPv;
    }

    public String getStartCost() {
        return startCost;
    }

    public void setStartCost(String startCost) {
        this.startCost = startCost;
    }

    public Float getStartCvr() {
        return startCvr;
    }

    public void setStartCvr(Float startCvr) {
        this.startCvr = startCvr;
    }

    public Long getRegistePv() {
        return registePv;
    }

    public void setRegistePv(Long registePv) {
        this.registePv = registePv;
    }

    public String getRegisteCost() {
        return registeCost;
    }

    public void setRegisteCost(String registeCost) {
        this.registeCost = registeCost;
    }

    public Float getRegisteCvr() {
        return registeCvr;
    }

    public void setRegisteCvr(Float registeCvr) {
        this.registeCvr = registeCvr;
    }

    public String getPayCost() {
        return payCost;
    }

    public void setPayCost(String payCost) {
        this.payCost = payCost;
    }

    public Float getPayCvr() {
        return payCvr;
    }

    public void setPayCvr(Float payCvr) {
        this.payCvr = payCvr;
    }

    public String getEntryCost() {
        return entryCost;
    }

    public void setEntryCost(String entryCost) {
        this.entryCost = entryCost;
    }

    public Float getEntryCvr() {
        return entryCvr;
    }

    public void setEntryCvr(Float entryCvr) {
        this.entryCvr = entryCvr;
    }

    public String getFinishCost() {
        return finishCost;
    }

    public void setFinishCost(String finishCost) {
        this.finishCost = finishCost;
    }

    public Float getFinishCvr() {
        return finishCvr;
    }

    public void setFinishCvr(Float finishCvr) {
        this.finishCvr = finishCvr;
    }
}
