/**
 * 
 */
package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;
import java.util.List;

import com.google.common.collect.Lists;

/**
 * 此类描述的是：分页查询共用返回结果.
 *
 * @param <T> the generic type
 * @author: leiliang
 * @version: 2016年2月25日 下午3:06:54
 */

public class PageDto<T> implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = -7934666904183628117L;

    /** The total count. */
    private int               totalCount;

    /** 总页数. */
    private int               totalPage;

    /** The data. */
    private List<T>           list;//NOSONAR

    /**
     * The Constructor.
     */
    public PageDto() {
        super();
    }

    /**
     * The Constructor.
     *
     * @param totalAmount 总记录数
     * @param list the list
     * @param pageSize 每页记录数
     */
    public PageDto(int totalAmount, List<T> list, int pageSize) {
        super();
        this.totalCount = totalAmount;
        this.list = list;
        this.totalPage = setPageCount(pageSize);
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private int setPageCount(int pageSize) {
        if (totalCount < 0 || pageSize <= 0) {
            return 0;
        }

        return (totalCount % pageSize == 0) ? totalCount / pageSize : totalCount / pageSize + 1;
    }

    /**
     * Gets the total page.
     *
     * @return the total page
     */
    public int getTotalPage() {
        return totalPage;
    }

    /**
     * Gets the total count.
     *
     * @return the totalCount
     */
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * Sets the total count.
     *
     * @param totalCount the totalCount to set
     */
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    /**
     * Gets the list.
     *
     * @return the list
     */
    public List<T> getList() {
        return list;
    }

    /**
     * Sets the list.
     *
     * @param list the list to set
     */
    public void setList(List<T> list) {
        this.list = list;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PageDto [totalCount=");
        builder.append(totalCount);
        builder.append(", totalPage=");
        builder.append(totalPage);
        builder.append(", list=");
        builder.append(list);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    /**
     * 构造空白分页对象
     * @return
     */
    public static <T> PageDto<T> emptyPage(){
        PageDto pageDto = new PageDto();
        pageDto.setList(Lists.newArrayList());
        pageDto.setTotalCount(0);
        pageDto.setPageCount(-1);
        return pageDto;
    }

}
